// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/tcp_server_socket.mojom
//

package org.chromium.mojom.mojo;

class TcpServerSocket_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy>() {
    
        public String getName() {
            return "mojo::TCPServerSocket";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, TcpServerSocket impl) {
            return new Stub(core, impl);
        }
    
        public TcpServerSocket[] buildArray(int size) {
          return new TcpServerSocket[size];
        }
    };

    private static final int ACCEPT_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements TcpServerSocket.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void accept(org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream, org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream, org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket, AcceptResponse callback) {
            TcpServerSocketAcceptParams _message = new TcpServerSocketAcceptParams();
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ACCEPT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpServerSocketAcceptResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<TcpServerSocket> {

        Stub(org.chromium.mojo.system.Core core, TcpServerSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TcpServerSocket_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TcpServerSocket_Internal.MANAGER, messageWithHeader, receiver);
                    case ACCEPT_ORDINAL: {
                        TcpServerSocketAcceptParams data =
                                TcpServerSocketAcceptParams.deserialize(messageWithHeader.getPayload());
                        getImpl().accept(data.sendStream, data.receiveStream, data.clientSocket, new TcpServerSocketAcceptResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class TcpServerSocketAcceptParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream;
        public org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream;
        public org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket;
    
        private TcpServerSocketAcceptParams(int version) {
            super(STRUCT_SIZE, version);
            sendStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
            receiveStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public TcpServerSocketAcceptParams() {
            this(0);
        }
    
        public static TcpServerSocketAcceptParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpServerSocketAcceptParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpServerSocketAcceptParams result = new TcpServerSocketAcceptParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(12, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sendStream, 8, false);
            encoder0.encode(receiveStream, 12, false);
            encoder0.encode(clientSocket, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpServerSocketAcceptParams other = (TcpServerSocketAcceptParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sendStream, other.sendStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiveStream, other.receiveStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.clientSocket, other.clientSocket))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sendStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiveStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(clientSocket);
            return result;
        }
    }

    static final class TcpServerSocketAcceptResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
        public NetAddress remoteAddress;
    
        private TcpServerSocketAcceptResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public TcpServerSocketAcceptResponseParams() {
            this(0);
        }
    
        public static TcpServerSocketAcceptResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpServerSocketAcceptResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpServerSocketAcceptResponseParams result = new TcpServerSocketAcceptResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
            encoder0.encode(remoteAddress, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpServerSocketAcceptResponseParams other = (TcpServerSocketAcceptResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.remoteAddress, other.remoteAddress))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(remoteAddress);
            return result;
        }
    }

    static class TcpServerSocketAcceptResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final TcpServerSocket.AcceptResponse mCallback;

        TcpServerSocketAcceptResponseParamsForwardToCallback(TcpServerSocket.AcceptResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ACCEPT_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                TcpServerSocketAcceptResponseParams response = TcpServerSocketAcceptResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.remoteAddress);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpServerSocketAcceptResponseParamsProxyToResponder implements TcpServerSocket.AcceptResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpServerSocketAcceptResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress remoteAddress) {
            TcpServerSocketAcceptResponseParams _response = new TcpServerSocketAcceptResponseParams();
            _response.result = result;
            _response.remoteAddress = remoteAddress;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ACCEPT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

